/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

//
// Happy Holidays Vostok Games!
// thanks to ztri/extend
// 

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// varying vec2 surfacePosition; // Not used in the original. TheEmu.

const float PI = 3.14159265;
const float PIh = 1.57079633;

float c_0 = 31599.0;
float c_1 = 9362.0;
float c_2 = 29671.0;
float c_3 = 29391.0;
float c_4 = 23497.0;
float c_5 = 31183.0;
float c_6 = 31215.0;
float c_7 = 29257.0;
float c_8 = 31727.0;
float c_9 = 31695.0;

float c_x = 23213.0;
float c_y = 23186.0;
float c_colon = 1040.0;
float c_period = 2.0;
float c_plus  = 1488.0;
float c_minus = 448.0;

float c_alpha[26];
// Popultes the c_alpha with floats that represent capital (latin) letters A through Z
void DefineCAlpha(){
    // via http://www.dafont.com/pixelzim3x5.font
    //A~111101111101101
    c_alpha[0] = 31725.;
    //B~111101110101111
    c_alpha[1] = 31663.;
    //C~111100100100111
    c_alpha[2] = 31015.;
    //D~110101101101110
    c_alpha[3] = 27502.;
    //E~111100110100111
    c_alpha[4] = 31143.;
    //F~111100110100100
    c_alpha[5] = 31140.;
    //G~111100101101111
    c_alpha[6] = 31087.;
    //H~101101111101101
    c_alpha[7] = 23533.;
    //I~111010010010111
    c_alpha[8] = 29847.;
    //J~001001001101111
    c_alpha[9] = 4719.;
    //K~101101110101101
    c_alpha[10] = 23469.;
    //L~100100100100111
    c_alpha[11] = 18727.;
    //M~101111101101101
    c_alpha[12] = 24429.;
    //N~001101111101100
    c_alpha[13] = 7148.;
    //O~111101101101111
    c_alpha[14] = 31599.;
    //P~111101111100100
    c_alpha[15] = 31716.;
    //Q~111101101111001
    c_alpha[16] = 31609.;
    //R~110101110101101
    c_alpha[17] = 27565.;
    //S~111100111001111
    c_alpha[18] = 31183.;
    //T~111010010010010
    c_alpha[19] = 29842.;
    //U~101101101101111
    c_alpha[20] = 23407.;
    //V~101101101101010
    c_alpha[21] = 23402.;
    //W~101101101111101
    c_alpha[22] = 23421.;
    //X~101101010101101
    c_alpha[23] = 23213.;
    //Y~101101010010010
    c_alpha[24] = 23186.;
    //Z~111001010100111
    c_alpha[25] = 29351.;
    
    c_alpha[25] = 2.*cos(time*.1001234567890)/(.5+sin(time));
    
    int beat[3];
    beat[0]=beat[1]=beat[2]=0;
    if(fract(time)<0.333)beat[0]=1;
    else if(fract(time)<0.667)beat[1]=1;
    else if(fract(time)<1.)beat[2]=1;
    c_alpha[24] = 1.*float(beat[0])+2.*float(beat[1])+4.*float(beat[2])
        +8.*(1.*float(beat[1])+2.*float(beat[2])+4.*float(beat[0]))
        +8.*8.*(1.*float(beat[2])+2.*float(beat[0])+4.*float(beat[1]))
        +8.*8.*8.*(1.*float(beat[0])+2.*float(beat[1])+4.*float(beat[2]))
        +8.*8.*8.*8.*(1.*float(beat[1])+2.*float(beat[2])+4.*float(beat[0]))
        ;
}


//returns 0/1 based on the state of the given bit in the given number
float getBit(float num,float bit)
{
    num = floor(num);
    bit = floor(bit);
    
    return float(mod(floor(num/pow(2.,bit)),2.) == 1.0);
}

float Sprite3x5(float sprite,vec2 p)
{
    float bounds = float(all(lessThan(p,vec2(3,5))) && all(greaterThanEqual(p,vec2(0,0))));
    
    return getBit(sprite,(2.0 - p.x) + 3.0 * p.y) * bounds;
}


float debugPrint( vec2 m, vec2 p ) {
    float c = 0.0;

    //Mouse X position
    vec2 cpos = vec2(0,46); 
    
    DefineCAlpha();
    cpos.x = 1.;cpos.y -= 6.;
    c += Sprite3x5(c_alpha[21],floor(p-cpos)); // V
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[14],floor(p-cpos)); // O
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[18],floor(p-cpos)); // S
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[19],floor(p-cpos)); // T
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[14],floor(p-cpos)); // O
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[10],floor(p-cpos)); // K
    cpos.x += 4.;

    
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[6],floor(p-cpos)); // G
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[0],floor(p-cpos)); // A
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[12],floor(p-cpos)); // M
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[4],floor(p-cpos)); // E
    cpos.x += 4.;
    c += Sprite3x5(c_alpha[18],floor(p-cpos)); // S
    cpos.x += 4.;
    
    return c;
}



vec3 rotatey(vec3 r, float v){  
  return vec3(r.x*sin(PIh-v)+r.z*sin(v),r.y,r.z*sin(PIh-v)-r.x*sin(v));
}

vec3 rotatex(vec3 r, float v){ 
  return vec3(r.y*sin(PIh-v)+r.z*sin(v),r.x,r.z*sin(PIh-v)-r.y*sin(v));
}

float rand3(vec3 n){ 
  return fract(sin(dot(n.xyz ,vec3(12.9898,78.233,4.1414))) * 43758.5453);
}

vec2 terrain(vec3 pos){ 
  vec3 p = vec3(mod(pos.x,500.0)-250.0,pos.y,-mod(pos.z,800.0)+400.0); 
  float d = sin(sin(pos.x-p.x)*1.12 +  sin(pos.z+p.z)*2.1);
  //p.y += sin(d*0.111)*sin(mouse.y+mouse.x+time*0.2)*1100.0;
  p = rotatey(p,sin(time*0.031-d)*10.0+sin(p.y*0.001+d*14.0+time+d*231.0));
  p = rotatex(p,sin(time*0.012+d)*10.0+sin(p.x*0.001+d*35.0+time+d*123.0));
  float t = pos.y;
  float size = 60.0;
  float sizew = 100.0 + 40.0 * sin(d*21.11);
  float sizel = 100.0 + 40.0 * sin(d*62.25) ;  
  float bandw = 10.0;
  float bandh = 1.0;
  float b = -99999999999999.0;
  b = max(b,   
          min(min(sizew-abs(p.x),size-abs(p.y)),sizel-abs(p.z)) 
          - rand3(floor(p*0.5))*0.1 
         );
  float s = -99999999999999.0;
  s = max(s,   
          min(min(bandw-abs(p.x),size+bandh-abs(p.y)),sizel+bandh-abs(p.z))
         );
  s = max(s,
  	  min(min(sizew+bandh-abs(p.x),size+bandh-abs(p.y)),bandw-abs(p.z)) 
    	);
  s = max(s, 
          -length(vec3(p.x*0.7+0.0,p.y*1.0+60.0,p.z))+9.0
         );
  vec3 r1 = rotatey(vec3(abs(p.x+0.0)-10.0,p.y+38.0,p.z-11.0),4.0);
  float s1 = -length(vec2(r1.x,r1.y*1.0+r1.x*-0.4))+30.0;
  s1 = min(s1 , 5.0-abs(r1.z));  
  s = max(s,s1);
  vec3 r2 = rotatex(rotatey(vec3(abs(p.x+0.0)-21.0,p.y+66.0,p.z+15.0),0.9),1.3);
  float s2 = -length(vec2(r2.x,r2.y*2.1))+30.0;
  s2 = min(min(s2, -s2+12.0),5.0-abs(r2.z));
  s = max(s,s2);
  if (b>s){
  	return vec2(b,abs(d));  
  } else {
  	return vec2(s,-1.0);
  }
}

vec3 env(vec3 dir){
 return vec3(0.7,0.8,1.0)*max(0.0,sin(rand3(floor(dir*3.0))))*(dir.y)*1.0;
}

void main(void){
    vec2  p = (2.0 * (scaled_gl_FragCoord.xy/resolution.xy))-1.0;
    vec2  m = vec2(0.0);
    vec3 campos = vec3(m.x*1000.0,m.y*1000.0-100.0,0.0-time*100.0);
    vec3 raydir = vec3(0.0,0.0,1.0);
    raydir = rotatey( raydir, (p.y*0.5));
    raydir = rotatex( raydir, (p.x*0.5*(resolution.x/resolution.y)));
    vec3 test = raydir;
    float h=0.0,d=0.0;
    for ( int iter = 1; iter < 100; iter ++ ){
      test += raydir*h;
      h = terrain(campos + test).x;
      d = length(test)/5000.0;
      if (abs(h)<0.1+d*0.5 || d>1.0 ){
        break;
      }
     }
    vec4 ohit = vec4(campos+test,h);
    vec3 hit = ohit.xyz;
	float axe = 3.0;
        float vx = terrain(hit+vec3(-axe, 0.0, 0.0)).x-terrain(hit+vec3( axe, 0.0, 0.0)).x;
        float vy = terrain(hit+vec3(0.0,-axe, 0.0)).x- terrain(hit+vec3(0.0, axe, 0.0)).x;
        float vz = terrain(hit+vec3(0.0,0.0,-axe)).x-terrain(hit+vec3(0.0,0.0, axe)).x;
 	vec3 n  = normalize(vec3(vx,vy,vz));
        float axe1 = 5.0;  
        float ao1 = terrain(hit+vec3(axe1,0.0,0.0)).x + terrain(hit+vec3(-axe1,0.0,0.0)).x 
            + terrain(hit+vec3(0.0,axe1,0.0)).x + terrain(hit+vec3(0.0,-axe1,0.0)).x 
            + terrain(hit+vec3(0.0,0.0,axe1)).x + terrain(hit+vec3(0.0,0.0,-axe1)).x;
  	float ao = clamp(1.0-(ao1)*0.12,0.0,1.0);    
        vec3 ambcol = vec3(0.3,0.4,0.5);
        vec2 mat = terrain(hit);
	vec3 col;
  	if(mat.y > 0.0){
          float cc = mod(mat.y*2.31,0.5);
       	   col = vec3(0.3+cc,0.1,0.4-cc) * ao;
           col += env(reflect(raydir,n)) * 0.5 * ao; 
        } else {
           col = vec3(0.8,0.7,0.2) * ao;      	 
           col += env(reflect(raydir,n)) * 3.0 * ao; 
        };       
        col = mix(col,ambcol, min(abs(ohit.w)*0.5,1.0)) ;
        col = col * (0.8-dot(p,p)*0.3);
        col += rand3(hit)*0.04;  
        float f = min(abs(time*0.3),1.0);
	
	
	vec2 pp = (2.0 * (scaled_gl_FragCoord.xy/resolution.xy))-1.0 + 0.8;
    	// vec2 mm = floor(mouse * resolution);
    	vec2 mm = vec2(0.0,0.0);
	
	float c = 0.0;
	c = debugPrint( mm, pp*30. );

        col = vec3(col.r*f,col.g*f*f,col.b*f);
    	gl_FragColor = vec4( vec3(mix(0.0,1.0,col.r + col.r*col.r*0.5),mix(0.0,1.0,col.g),mix(0.0,0.90,col.b)), 1.0 );
	gl_FragColor += vec4(vec3(c),1.0); 
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}
